---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：1-JUnit XMLレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的なベンチマーク根拠なし
  2. **想定データ件数**：実際の制限値の根拠不明

## 2) 参照した情報（Evidence一覧）

- E-01: `src/cli/test_command.zig` JunitReporter構造体定義（73-171行目）
- E-02: `src/cli/test_command.zig` Metrics構造体（129-142行目）
- E-03: `src/cli/test_command.zig` SuiteInfo構造体（115-127行目）
- E-04: `src/cli/test_command.zig` beginTestSuite関数（266-329行目）
- E-05: `src/cli/test_command.zig` writeTestCase関数（372-518行目）
- E-06: `src/cli/test_command.zig` endTestSuite関数（331-370行目）
- E-07: `src/cli/test_command.zig` writeToFile関数（520-566行目）
- E-08: `src/cli/test_command.zig` generatePropertiesList関数（173-257行目）
- E-09: `src/cli/test_command.zig` escapeXml関数（4-41行目）
- E-10: `src/cli/test_command.zig` maybePrintJunitLine関数（721-861行目）
- E-11: `src/cli/test_command.zig` handleTestCompleted関数（867-953行目）
- E-12: `src/cli/test_command.zig` TestCommand.exec関数（1307-1600行目）
- E-13: `src/bunfig.zig` test.reporter.junit設定パース（288-296行目）
- E-14: `src/cli/Arguments.zig` --reporter, --reporter-outfile引数定義（229-230行目）
- E-15: `src/cli/test_command.zig` XMLヘッダー出力（271-279行目）
- E-16: `src/cli/test_command.zig` getHostname関数（87-113行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JUnit XML形式でテスト結果を出力する | E-01, E-04, E-05, E-07 | ○ |
| C-02 | ファイル形式はXML（UTF-8） | E-15 | ○ |
| C-03 | ルート要素は`<testsuites>` | E-04 (278行目) | ○ |
| C-04 | testsuites要素にname="bun test"属性 | E-04 (277行目) | ○ |
| C-05 | testsuites要素にtests, assertions, failures, skipped, time属性 | E-07 (534-542行目) | ○ |
| C-06 | testsuite要素にname, file, tests, assertions, failures, skipped, time, hostname属性 | E-06 (348-357行目) | ○ |
| C-07 | testcase要素にname, classname, file, line, time, assertions属性 | E-05 (394-412行目) | ○ |
| C-08 | 失敗テストにはfailure子要素が付加される | E-05 (418-432行目) | ○ |
| C-09 | スキップテストにはskipped子要素が付加される | E-05 (486-504行目) | ○ |
| C-10 | タイムアウトエラーはtype="TimeoutError"で出力 | E-05 (506-515行目) | ○ |
| C-11 | 特殊文字はXMLエスケープされる | E-09 (4-41行目) | ○ |
| C-12 | 制御文字は数値参照形式でエスケープ | E-09 (31-34行目) | ○ |
| C-13 | CI環境変数からproperties要素を生成 | E-08 (173-257行目) | ○ |
| C-14 | GITHUB_RUN_ID等からCI URLを構築 | E-08 (184-193行目) | ○ |
| C-15 | GITHUB_SHA等からcommit情報を取得 | E-08 (203-223行目) | ○ |
| C-16 | ネストしたdescribeはネストしたtestsuite要素で出力 | E-10 (766-836行目) | ○ |
| C-17 | --reporter=junitオプションで有効化 | E-14 (229行目) | ○ |
| C-18 | bunfig.tomlのtest.reporter.junitで有効化 | E-13 (288-296行目) | ○ |
| C-19 | writeToFileでファイルに書き込み | E-07 (520-566行目) | ○ |
| C-20 | ファイル書き込み失敗時にエラーメッセージ出力 | E-07 (553-562行目) | ○ |
| C-21 | Windowsではhostname取得がスキップされる | E-16 (89-91行目) | ○ |
| C-22 | 実行時間は秒単位（ミリ秒から変換） | E-06 (343-345行目) | ○ |
| C-23 | testcase実行時間はナノ秒から秒に変換 | E-05 (382-383行目, 401-402行目) | ○ |
| C-24 | classnameはdescribeスコープを">"で連結 | E-10 (843-855行目) | ○ |
| C-25 | Metrics構造体でtest_cases, assertions, failures, skipped, elapsed_timeを管理 | E-02 (129-142行目) | ○ |
| C-26 | suite_stackでネストしたsuiteを管理 | E-03, E-01 (82行目) | ○ |
| C-27 | インデントは深度に応じて2スペース単位 | E-04 (259-264行目) | ○ |
| C-28 | 全テスト完了後にtestsuites閉じタグを出力 | E-07 (544行目) | ○ |
| C-29 | TODOテストはskipped要素のmessage="TODO"で出力 | E-05 (496-504行目) | ○ |
| C-30 | failing()マーク付きテストが通過した場合の失敗メッセージ | E-05 (434-446行目) | ○ |
| C-31 | 想定データ件数は数千テストケース | **根拠なし** | △ |
| C-32 | 目標出力時間はテスト実行時間の1%未満 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **パフォーマンス要件（C-31, C-32）**：ソースコード上に具体的なパフォーマンス目標や制限値の記載がない
  - 候補：ベンチマークテスト / 設計ドキュメント / イシュー・PR

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - XML生成ロジック、エスケープ処理、属性出力
- **0: 低リスク** - CI環境変数からの情報取得
- **1: 中リスク** - パフォーマンス要件（実測値に基づく検証が望ましい）

## 6) レビュアーチェックリスト（最小）

- [ ] JunitReporter構造体の定義とフィールドが設計書と一致するか確認
- [ ] writeTestCase関数の状態分岐（pass/fail/skip/todo/timeout）が網羅されているか確認
- [ ] XMLエスケープ処理が全ての特殊文字をカバーしているか確認
- [ ] CI環境変数の取得ロジック（GitHub Actions/GitLab CI）が正確か確認
- [ ] パフォーマンス要件について実際のテスト実行で検証
